/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MyPanel.java
 *
 * Created on 26-05-2011, 23:46:01
 */
package Presentation;

import RSCall.DiaOcRSc;
import RSCall.DuongRSc;
import RSCall.HinhAnhRSc;
import RSCall.NoiDungRSc;
import RSCall.PhuongRSc;
import RSCall.QuanRSc;
import RSCall.ThanhPhoRSc;
import Entities.DIAOC;
import Entities.HINHANH;
import Entities.NOIDUNGQC;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

/**
 *
 * @author Nixforest
 */
public class MyPanel extends javax.swing.JPanel {

    /** Creates new form MyPanel
     * @param rootpn
     * @param maDiaOc */
    public MyPanel(JInternalFrame rootpn, String maDiaOc) {        
        initComponents();
        Creation();
        myParent = rootpn;
        MaDiaOc = maDiaOc;
        LoadData();        
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlImg = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        txtAreaInfo = new javax.swing.JTextArea();
        jScrollPane4 = new javax.swing.JScrollPane();
        txtAreaNoiDungQC = new javax.swing.JTextArea();
        btnChiTiet = new javax.swing.JButton();

        setBackground(new java.awt.Color(224, 224, 255));
        setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));
        setPreferredSize(new java.awt.Dimension(380, 310));

        pnlImg.setBackground(new java.awt.Color(224, 224, 255));
        pnlImg.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.LOWERED));
        pnlImg.setPreferredSize(new java.awt.Dimension(180, 140));

        javax.swing.GroupLayout pnlImgLayout = new javax.swing.GroupLayout(pnlImg);
        pnlImg.setLayout(pnlImgLayout);
        pnlImgLayout.setHorizontalGroup(
            pnlImgLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        pnlImgLayout.setVerticalGroup(
            pnlImgLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );

        txtAreaInfo.setEditable(false);
        txtAreaInfo.setBackground(new java.awt.Color(240, 240, 240));
        txtAreaInfo.setColumns(20);
        txtAreaInfo.setLineWrap(true);
        txtAreaInfo.setRows(5);
        txtAreaInfo.setWrapStyleWord(true);
        txtAreaInfo.setAutoscrolls(false);
        txtAreaInfo.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        txtAreaInfo.setPreferredSize(new java.awt.Dimension(180, 210));
        jScrollPane1.setViewportView(txtAreaInfo);

        txtAreaNoiDungQC.setEditable(false);
        txtAreaNoiDungQC.setBackground(new java.awt.Color(240, 240, 240));
        txtAreaNoiDungQC.setColumns(20);
        txtAreaNoiDungQC.setLineWrap(true);
        txtAreaNoiDungQC.setRows(5);
        txtAreaNoiDungQC.setWrapStyleWord(true);
        txtAreaNoiDungQC.setAutoscrolls(false);
        txtAreaNoiDungQC.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 1, 1, 1));
        txtAreaNoiDungQC.setPreferredSize(new java.awt.Dimension(180, 110));
        jScrollPane4.setViewportView(txtAreaNoiDungQC);

        btnChiTiet.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("detail") );
        btnChiTiet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnChiTietActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(pnlImg, javax.swing.GroupLayout.DEFAULT_SIZE, 192, Short.MAX_VALUE)
                    .addComponent(jScrollPane4, javax.swing.GroupLayout.DEFAULT_SIZE, 192, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addComponent(btnChiTiet, javax.swing.GroupLayout.DEFAULT_SIZE, 147, Short.MAX_VALUE))
                .addContainerGap(31, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(pnlImg, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jScrollPane4, javax.swing.GroupLayout.PREFERRED_SIZE, 121, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 216, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnChiTiet, javax.swing.GroupLayout.DEFAULT_SIZE, 50, Short.MAX_VALUE)))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void btnChiTietActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnChiTietActionPerformed
        MaND = ""; //NOI18N
        try {
            MaND = dbDiaOc.GetMaND_From_MaDiaOc(MaDiaOc);
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(myParent.getRootPane(), ex.toString());
            Logger.getLogger(frmDiaOc.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (MaND.equals("")) { //NOI18N
            JOptionPane.showMessageDialog(myParent.getRootPane(), "Địa ốc này chưa đăng ký rao bán!"); //NOI18N
        }else{
            frmNoiDungQC f = new frmNoiDungQC(MaND);
            Utilities.Utilities.setFontForAll(f, new Font("Calibri", 0, 14)); //NOI18N
            f.setLocation(155, 0);
            f.setClosable(true);
            f.show();
            this.myParent.getParent().add(f,0);
        }
//            this.getParent().getParent().getParent().add(f,0);
    }//GEN-LAST:event_btnChiTietActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnChiTiet;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JPanel pnlImg;
    private javax.swing.JTextArea txtAreaInfo;
    private javax.swing.JTextArea txtAreaNoiDungQC;
    // End of variables declaration//GEN-END:variables
    
    private final String MaDiaOc;
    private String MaND = null;
    private ArrayList<HINHANH> imageList;
    private Entities.DIAOC diaOc;
    private Entities.NOIDUNGQC noiDungQC;
    private RSCall.HinhAnhRSc dbHinhAnh;
    private JInternalFrame myParent;
    private RSCall.DiaOcRSc dbDiaOc;
    private RSCall.NoiDungRSc dbNoiDungQC;
    private RSCall.ThanhPhoRSc dbThanhPho;
    private RSCall.QuanRSc dbQuan;
    private RSCall.PhuongRSc dbPhuong;
    private RSCall.DuongRSc dbDuong;
    
    private void Creation(){
        try{
            dbDiaOc = new DiaOcRSc();
            dbNoiDungQC = new NoiDungRSc();
            imageList = new ArrayList<HINHANH>();
            diaOc = new DIAOC();
            noiDungQC = new NOIDUNGQC();
            dbHinhAnh = new HinhAnhRSc();
            myParent = new JInternalFrame();
            dbThanhPho = new ThanhPhoRSc();
            dbQuan = new QuanRSc();
            dbPhuong = new PhuongRSc();
            dbDuong = new DuongRSc();
        }catch(Exception e){
            JOptionPane.showMessageDialog(myParent.getRootPane(), e.toString());
            Logger.getLogger(MyPanel.class.getName()).log(Level.SEVERE, null, e);
        }
    }
    
    private void LoadData(){
        try {
            diaOc = new RSCall.DiaOcRSc().GetRowByID(MaDiaOc);
            
            // Lấy MaND từ MaDiaOc
            MaND = dbDiaOc.GetMaND_From_MaDiaOc(MaDiaOc);
            noiDungQC = dbNoiDungQC.GetRowByID(MaND);
            
            // Tạo ảnh thumbnail
            String Anh = ""; //NOI18N
            Boolean coHinhAnh = dbHinhAnh.IsMaND_HinhAnhExist(MaND);
            if (coHinhAnh) {
                imageList = dbHinhAnh.SelectHinhAnhByMaND(MaND);

                pnlImg.setLayout(new FlowLayout());
                pnlImg.removeAll();
                if (!imageList.isEmpty()) {
                    Anh = imageList.get(0).getAnh();
                }
                URL url = getClass().getResource("../Images/" + Anh); //NOI18N
                Image img = Toolkit.getDefaultToolkit().getImage(url).getScaledInstance(180, 135, BufferedImage.SCALE_SMOOTH);
                ImageIcon icon = new ImageIcon(img);
                JLabel l = new JLabel(icon);
                pnlImg.add(l);
            }
            
            // Tạo nội dung quảng cáo
            String tenThanhPho = dbThanhPho.GetRowByID(diaOc.getDiaChiDiaOc().getMaThanhPho()).getTenThanhPho().trim();
            String tenQuan = dbQuan.GetRowByID(diaOc.getDiaChiDiaOc().getMaQuan()).getTenQuan().trim();
            String tenPhuong = dbPhuong.GetRowByID(diaOc.getDiaChiDiaOc().getMaPhuong()).getTenPhuong().trim();
            String tenDuong = dbDuong.GetRowByID(diaOc.getDiaChiDiaOc().getMaDuong()).getTenDuong().trim();
            String diaChiCT = diaOc.getDiaChiDiaOc().getDiaChiCT().trim();
            txtAreaNoiDungQC.setText(noiDungQC.getThongTinDiaOc().trim() + "\n\n"
                    + java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("address") + ": " + diaChiCT + " " + tenDuong + " " //NOI18N
                    + tenPhuong + " " + tenQuan + " " + tenThanhPho); //NOI18N
            txtAreaInfo.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("s1") + ": " + Float.toString(diaOc.getDienTichDat()) + " m2 \n"
                    + java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("s2") + ": " + Float.toString(diaOc.getDienTichXayDung()) + " m2 \n"
                    + java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("direction") + ": " + diaOc.getHuong().trim() + "\n"
                    + java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("location") + ": " + diaOc.getViTri().trim() + "\n\n"
                    + java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("cost") + ": " + Float.toString(diaOc.getGiaBan()));
            
            
        } catch (Exception ex) {
            JOptionPane.showMessageDialog(myParent.getRootPane(), ex.toString());
            Logger.getLogger(MyPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}
